
//==============================================================================
// Project:		Wealth transfers and their economic effects
// File name:	Figure B.11
// Objective: 	Generate the data underpinning figure B.11
//
//==============================================================================

clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 wave using CPI.dta //CPI data
drop if _merge == 2
drop _merge

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge


xtset xwaveid wave

************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -10 | oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due to HH deaths
 
gen net_worth = hwnwip - hwnwin //household net worth

rename wlebf weight_2_6 //weights
rename wlefj weight_6_10
rename wlejn weight_10_14
rename wlenr weight_14_18
gen weight_4 = 0
replace weight_4 = weight_2_6 if wave == 2
replace weight_4 = weight_6_10 if wave == 6
replace weight_4 = weight_10_14 if wave == 10
replace weight_4 = weight_14_18 if wave == 14

rename wlebj weight_2_10 //weights
rename wlefn weight_6_14
rename wlejr weight_10_18
gen weight_8 = weight_2_10 if wave == 2
replace weight_8 = weight_6_14 if wave == 6
replace weight_8 = weight_10_18 if wave == 10

gen child = 1 if hgage < 15 //generate equivalisation scale (OECD modified)
gen adult = 1 if hgage >= 15
egen total_child = total(child), by(hhrhid wave)
egen total_adult = total(adult), by(hhrhid wave)
gen equiv_scale = total_child*0.3 + total_adult*0.5 + 0.5 //0.3 for children, 1 for first adult and 0.5 for all subsequent adults

egen total_bequest = total(bequest), by(hhrhid wave)
gen bequest_e = total_bequest * 100 / (equiv_scale*CPI) //real equivalised inheritances

gen net_worth_e_LT4 = (net_worth * 100 / (equiv_scale*CPI)) - .989058*(bequest_e + L.bequest_e + L2.bequest_e) //real equivalised net worth pre inheritances

gen net_worth_bequest_e_LT4 = net_worth * 100 / (equiv_scale*CPI) //real equivalised net worth post inheritances

gen net_worth_e_LT8 = (net_worth * 100 / (equiv_scale*CPI)) - .9096321*(L4.bequest_e + L5.bequest_e + L6.bequest_e) //real equivalised net worth pre inheritances

gen net_worth_bequest_e_LT8 = net_worth * 100 / (equiv_scale*CPI) //real equivalised net worth post inheritances

gen net_worth_e_IT = net_worth * 100 / (equiv_scale*CPI) //real equivalised net worth

gen net_worth_bequest_e_IT = net_worth * 100 / (equiv_scale*CPI) + F2.bequest_e + F3.bequest_e + F4.bequest_e


local wealth_waves 2 6 10
foreach x of local wealth_waves{
	ineqdec0 net_worth_e_IT [aweight = weight_8] if wave == `x' & F8.net_worth_e_LT8 != .
	matrix gini_IT_`x' = r(gini)
	scalar gini_IT_`x'_s = gini_IT_`x'[1,1]
	mean net_worth_e_IT [pweight = weight_8] if wave == `x' & F8.net_worth_e_LT8 != .
	matrix mean_IT_`x' = e(b)
	scalar mean_IT_`x'_s = mean_IT_`x'[1,1] 
	ineqdec0 net_worth_bequest_e_IT [aweight = weight_8] if wave == `x' & F8.net_worth_e_LT8 != .
	matrix gini_bequest_IT_`x' = r(gini)
	scalar gini_bequest_IT_`x'_s = gini_bequest_IT_`x'[1,1]
	mean net_worth_bequest_e_IT [pweight = weight_8] if wave == `x' & F8.net_worth_e_LT8 != .
	matrix mean_bequest_IT_`x' = e(b)
	scalar mean_bequest_IT_`x'_s = mean_bequest_IT_`x'[1,1]
}

scalar gini_IT_pc_diff = ((gini_bequest_IT_2_s + gini_bequest_IT_6_s + gini_bequest_IT_10_s ) - (gini_IT_2_s + gini_IT_6_s + gini_IT_10_s ))*100 / (gini_IT_2_s + gini_IT_6_s + gini_IT_10_s)

scalar abs_gini_IT_pc_diff = ((gini_bequest_IT_2_s * mean_bequest_IT_2_s + gini_bequest_IT_6_s * mean_bequest_IT_6_s + gini_bequest_IT_10_s * mean_bequest_IT_10_s ) - (gini_IT_2_s * mean_IT_2_s + gini_IT_6_s * mean_IT_6_s + gini_IT_10_s * mean_IT_10_s))*100 / (gini_IT_2_s * mean_IT_2_s + gini_IT_6_s * mean_IT_6_s + gini_IT_10_s * mean_IT_10_s)

local wealth_waves 6 10 14
foreach x of local wealth_waves{
	ineqdec0 net_worth_e_LT4 [aweight = L4.weight_8] if wave == `x' & F4.net_worth_e_LT8 != .
	matrix gini_LT4_`x' = r(gini)
	scalar gini_LT4_`x'_s = gini_LT4_`x'[1,1]
	mean net_worth_e_LT4 [pweight = L4.weight_8] if wave == `x' & F4.net_worth_e_LT8 != .
	matrix mean_LT4_`x' = e(b)
	scalar mean_LT4_`x'_s = mean_LT4_`x'[1,1]
	ineqdec0 net_worth_bequest_e_LT4 [aweight = L4.weight_8] if wave == `x' & F4.net_worth_e_LT8 != .
	matrix gini_bequest_LT4_`x' = r(gini)
	scalar gini_bequest_LT4_`x'_s = gini_bequest_LT4_`x'[1,1]
	mean net_worth_bequest_e_LT4 [pweight = L4.weight_8] if wave == `x' & F4.net_worth_e_LT8 != .
	matrix mean_bequest_LT4_`x' = e(b)
	scalar mean_bequest_LT4_`x'_s = mean_bequest_LT4_`x'[1,1]
}

scalar gini_LT4_pc_diff = ((gini_bequest_LT4_6_s + gini_bequest_LT4_10_s + gini_bequest_LT4_14_s) - (gini_LT4_6_s + gini_LT4_10_s + gini_LT4_14_s))*100 / (gini_LT4_6_s + gini_LT4_10_s + gini_LT4_14_s)

scalar abs_gini_LT4_pc_diff = ((gini_bequest_LT4_6_s * mean_bequest_LT4_6_s + gini_bequest_LT4_10_s * mean_bequest_LT4_10_s + gini_bequest_LT4_14_s * mean_bequest_LT4_14_s) - (gini_LT4_6_s * mean_LT4_6_s + gini_LT4_10_s * mean_LT4_10_s + gini_LT4_14_s * mean_LT4_14_s))*100 / (gini_LT4_6_s * mean_LT4_6_s + gini_LT4_10_s * mean_LT4_10_s + gini_LT4_14_s * mean_LT4_14_s)

local wealth_waves 10 14 18
foreach x of local wealth_waves{
	local z1 = `y1' + 10
	local y2 = `y1' + 4
	local z2 = `z1' + 4
	local y3 = `y1' + 8
	local z3 = `z1' + 8
	ineqdec0 net_worth_e_LT8 [aweight = L8.weight_8] if wave == `x' & net_worth_e_LT8 != .
	matrix gini_LT8_`x' = r(gini)
	scalar gini_LT8_`x'_s = gini_LT8_`x'[1,1]
	mean net_worth_e_LT8 [pweight = L8.weight_8] if wave == `x' & net_worth_e_LT8 != .
	matrix mean_LT8_`x' = e(b)
	scalar mean_LT8_`x'_s = mean_LT8_`x'[1,1]
	ineqdec0 net_worth_bequest_e_LT8 [aweight = L8.weight_8] if wave == `x' & net_worth_e_LT8 != .
	matrix gini_bequest_LT8_`x' = r(gini)
	scalar gini_bequest_LT8_`x'_s = gini_bequest_LT8_`x'[1,1]
	mean net_worth_bequest_e_LT8 [pweight = L8.weight_8] if wave == `x' & net_worth_e_LT8 != .
	matrix mean_bequest_LT8_`x' = e(b)
	scalar mean_bequest_LT8_`x'_s = mean_bequest_LT8_`x'[1,1]
}

scalar gini_LT8_pc_diff = ((gini_bequest_LT8_10_s + gini_bequest_LT8_14_s + gini_bequest_LT8_18_s) - (gini_LT8_10_s + gini_LT8_14_s + gini_LT8_18_s))*100 / (gini_LT8_10_s + gini_LT8_14_s + gini_LT8_18_s)

scalar abs_gini_LT8_pc_diff = ((gini_bequest_LT8_10_s * mean_bequest_LT8_10_s + gini_bequest_LT8_14_s * mean_bequest_LT8_14_s + gini_bequest_LT8_18_s * mean_bequest_LT8_18_s) - (gini_LT8_10_s * mean_LT8_10_s + gini_LT8_14_s * mean_LT8_14_s + gini_LT8_18_s * mean_LT8_18_s))*100 / (gini_LT8_10_s * mean_LT8_10_s + gini_LT8_14_s * mean_LT8_14_s + gini_LT8_18_s * mean_LT8_18_s)


scalar list gini_IT_pc_diff //figure B.11, panel b
scalar list gini_LT4_pc_diff
scalar list gini_LT8_pc_diff

scalar list abs_gini_IT_pc_diff //figure B.11, panel a
scalar list abs_gini_LT4_pc_diff
scalar list abs_gini_LT8_pc_diff


